'use strict';

/* --------------------------------------------------------------
 quick_edit_overview_columns.js 2016-09-29
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

jse.libs.quick_edit_overview_columns = jse.libs.quick_edit_overview_columns || {};

(function (exports) {

    'use strict';

    exports.checkbox = exports.checkbox || {
        data: null,
        minWidth: '50px',
        widthFactor: 0.01,
        orderable: false,
        searchable: false,
        render: function render() {
            return '<input type="checkbox" class="overview-row-selection" />';
        }
    };

    exports.id = exports.id || {
        data: 'id',
        minWidth: '65px',
        widthFactor: 0.6
    };

    exports.category = exports.category || {
        data: 'category',
        minWidth: '150px',
        widthFactor: 1.5
    };

    exports.name = exports.name || {
        data: 'name',
        minWidth: '190px',
        widthFactor: 1.5,
        className: 'editable'
    };

    exports.model = exports.model || {
        data: 'model',
        minWidth: '90px',
        widthFactor: 1.2,
        className: 'editable'
    };

    exports.manufacturer = exports.manufacturer || {
        data: 'manufacturer',
        minWidth: '150px',
        widthFactor: 1.5,
        className: 'editable manufacturer'
    };

    exports.quantity = exports.quantity || {
        data: 'quantity',
        minWidth: '75px',
        widthFactor: 1,
        className: 'numeric editable'
    };

    exports.price = exports.price || {
        data: 'price',
        minWidth: '85px',
        widthFactor: 1.2,
        className: 'numeric editable product-price'
    };

    exports.discount = exports.discount || {
        data: 'discount',
        minWidth: '75px',
        widthFactor: 1,
        className: 'numeric editable'
    };

    exports.specialPrice = exports.specialPrice || {
        data: 'specialPrice',
        minWidth: '85px',
        widthFactor: 1.2,
        className: 'numeric editable tooltip-products-special-price'
    };

    exports.tax = exports.tax || {
        data: 'tax',
        minWidth: '85px',
        widthFactor: 1.2,
        render: function render(data, type, full, meta) {
            var html = '';
            var options = full.DT_RowData.option.tax;

            options.forEach(function (option) {
                html += '<option value="' + option.id + '" ' + (full.taxClassId == option.id ? 'selected' : '') + '>\n\t\t\t\t\t\t\t' + option.value + '\n\t\t\t\t\t\t</option>';
            });

            return '<select class="form-control select-tax">' + html + '</select>';
        }
    };

    exports.shippingStatusName = exports.shippingStatusName || {
        data: 'shippingStatusName',
        minWidth: '100px',
        widthFactor: 1.2,
        render: function render(data, type, full, meta) {
            var html = '';
            var options = full.DT_RowData.option.shipment;

            options.forEach(function (option) {
                html += '<option value="' + option.id + '" ' + (full.shippingTimeId == option.id ? 'selected' : '') + '>\n\t\t\t\t\t\t\t' + option.value + '\n\t\t\t\t\t\t</option>';
            });

            return '<select class="form-control select-shipping-time">' + html + '</select>';
        }
    };

    exports.weight = exports.weight || {
        data: 'weight',
        minWidth: '75px',
        widthFactor: 1.2,
        className: 'numeric editable'
    };

    exports.shippingCosts = exports.shippingCosts || {
        data: 'shippingCosts',
        minWidth: '85px',
        widthFactor: 1.2,
        className: 'numeric editable'
    };

    exports.status = exports.status || {
        data: 'status',
        minWidth: '85px',
        widthFactor: 1.2,
        className: 'status',
        searchable: false,
        render: function render(data) {
            return '<input type="checkbox" ' + (data ? "checked" : "") + ' class="convert-to-switcher" />';
        }
    };

    exports.actions = exports.actions || {
        data: null,
        minWidth: '450px',
        widthFactor: 5.2,
        className: 'actions',
        orderable: false,
        searchable: false,
        render: function render(data, type, full, meta) {
            return '\t\t\t\t\t\n\t\t\t\t\t<div class="pull-left"></div>\n\t\t\t\t\t<div class="pull-right action-list visible-on-hover">\n\t\t\t\t\t\t<i class="fa fa-pencil row-edit"></i>\n\t\t\t\t\t\t<i class="fa fa-eye show-product"></i>\n\t\t\t\t\t\n\t\t\t\t\t\t<div class="btn-group dropdown">\n\t\t\t\t\t\t\t<button type="button"\n\t\t\t\t\t\t\t\t\tclass="btn btn-default"></button>\n\t\t\t\t\t\t\t<button type="button"\n\t\t\t\t\t\t\t\t\tclass="btn btn-default dropdown-toggle"\n\t\t\t\t\t\t\t\t\tdata-toggle="dropdown"\n\t\t\t\t\t\t\t\t\taria-haspopup="true"\n\t\t\t\t\t\t\t\t\taria-expanded="false">\n\t\t\t\t\t\t\t\t<span class="caret"></span>\n\t\t\t\t\t\t\t\t<span class="sr-only">Toggle Dropdown</span>\n\t\t\t\t\t\t\t</button>\n\t\t\t\t\t\t\t<ul class="dropdown-menu dropdown-menu-right"></ul>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t';
        }
    };
})(jse.libs.quick_edit_overview_columns);
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
